/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import pse.assessment.PantherAssessment;
import pse.assessment.PantherForm;
import pse.assessment.PantherMediaObject;
import pse.assessment.PantherTask;
import pse.util.general.ErrorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssessmentStore {
    protected static Map<String, PantherAssessment> assessments = new HashMap<String, PantherAssessment>();
    protected static Map<String, PantherForm> forms = new HashMap<String, PantherForm>();
    protected static Map<String, PantherTask> tasks = new HashMap<String, PantherTask>();
    protected static Map<String, PantherMediaObject> mediaObjects = new HashMap<String, PantherMediaObject>();
    protected static boolean cacheUpdateGateTaken = false;
    protected static final Object cacheUpdateGate = "Panther Assessments Cache Update Gate";
    protected static Logger logger = Logger.getLogger(AssessmentStore.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Collection<PantherAssessment> collection, Collection<PantherForm> collection2, Collection<PantherTask> collection3) {
        try {
            AssessmentStore.takeCacheUpdateGate();
            for (PantherAssessment assessmentObject : collection) {
                assessments.put(assessmentObject.getVdsIdent(), assessmentObject);
            }
            for (PantherForm pantherForm : collection2) {
                forms.put(pantherForm.getVdsIdent(), pantherForm);
            }
            for (PantherTask pantherTask : collection3) {
                tasks.put(pantherTask.getVdsIdent(), pantherTask);
            }
        }
        finally {
            AssessmentStore.releaseCacheUpdateGate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMediaObjects(Collection<PantherMediaObject> collection) {
        try {
            AssessmentStore.takeCacheUpdateGate();
            for (PantherMediaObject pantherMediaObject : collection) {
                mediaObjects.put(pantherMediaObject.getVdsIdent(), pantherMediaObject);
            }
        }
        finally {
            AssessmentStore.releaseCacheUpdateGate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTasks(Collection<PantherTask> collection) {
        try {
            AssessmentStore.takeCacheUpdateGate();
            for (PantherTask pantherTask : collection) {
                tasks.put(pantherTask.getVdsIdent(), pantherTask);
            }
        }
        finally {
            AssessmentStore.releaseCacheUpdateGate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PantherAssessment getAssessment(String string) {
        PantherAssessment pantherAssessment = null;
        try {
            AssessmentStore.takeCacheUpdateGate();
            pantherAssessment = assessments.get(string);
        }
        finally {
            AssessmentStore.releaseCacheUpdateGate();
        }
        return pantherAssessment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, PantherAssessment> getAssessmentMap() {
        try {
            AssessmentStore.takeCacheUpdateGate();
            HashMap<String, PantherAssessment> hashMap = new HashMap<String, PantherAssessment>(assessments);
            return hashMap;
        }
        finally {
            AssessmentStore.releaseCacheUpdateGate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PantherForm getForm(String string) {
        PantherForm pantherForm = null;
        try {
            AssessmentStore.takeCacheUpdateGate();
            pantherForm = forms.get(string);
        }
        finally {
            AssessmentStore.releaseCacheUpdateGate();
        }
        return pantherForm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, PantherForm> getFormMap() {
        try {
            AssessmentStore.takeCacheUpdateGate();
            HashMap<String, PantherForm> hashMap = new HashMap<String, PantherForm>(forms);
            return hashMap;
        }
        finally {
            AssessmentStore.releaseCacheUpdateGate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PantherMediaObject getMediaObject(String string) {
        PantherMediaObject pantherMediaObject = null;
        try {
            AssessmentStore.takeCacheUpdateGate();
            pantherMediaObject = mediaObjects.get(string);
        }
        finally {
            AssessmentStore.releaseCacheUpdateGate();
        }
        return pantherMediaObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, PantherMediaObject> getMediaObjectMap() {
        try {
            AssessmentStore.takeCacheUpdateGate();
            HashMap<String, PantherMediaObject> hashMap = new HashMap<String, PantherMediaObject>(mediaObjects);
            return hashMap;
        }
        finally {
            AssessmentStore.releaseCacheUpdateGate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PantherTask getTask(String string) {
        PantherTask pantherTask = null;
        try {
            AssessmentStore.takeCacheUpdateGate();
            pantherTask = tasks.get(string);
        }
        finally {
            AssessmentStore.releaseCacheUpdateGate();
        }
        return pantherTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, PantherTask> getTaskMap() {
        try {
            AssessmentStore.takeCacheUpdateGate();
            HashMap<String, PantherTask> hashMap = new HashMap<String, PantherTask>(tasks);
            return hashMap;
        }
        finally {
            AssessmentStore.releaseCacheUpdateGate();
        }
    }

    public static void initialize() throws Exception {
        logger.warning("Assessment Store initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void releaseCacheUpdateGate() {
        Object object = cacheUpdateGate;
        synchronized (object) {
            cacheUpdateGateTaken = false;
            try {
                cacheUpdateGate.notify();
            }
            catch (Throwable throwable) {
                ErrorUtils.checkSwallow(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void takeCacheUpdateGate() {
        Object object = cacheUpdateGate;
        synchronized (object) {
            if (cacheUpdateGateTaken) {
                AssessmentStore.waitAndTakeCacheUpdateGate();
            } else {
                cacheUpdateGateTaken = true;
            }
        }
    }

    protected static void waitAndTakeCacheUpdateGate() {
        try {
            cacheUpdateGate.wait();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            ErrorUtils.checkSwallow(throwable);
        }
        AssessmentStore.takeCacheUpdateGate();
    }
}

